package dfatool.strategy.graph;

import java.util.HashSet;
import java.util.Set;

public class SpanningTree {
	
	TarjanNode root;
	
	IGraph graph;
	
	public SpanningTree(INode node) {
		graph = new Graph();
		root = DFS(null,node);
	}
	

	public TarjanNode DFS(INode predecessor,INode node){
		TarjanNode tn = new TarjanNode((NodeIdentifier) node.getIdentifier());
		if(!graph.hasNode(tn))
			graph.addNode(tn);
		for(INode n : node.getConnections()){
			if (!graph.hasNode(n))
				tn.getTreeConnections().add(DFS(node,n));
			else if(predecessor != null && !predecessor.getIdentifier().equals(n.getIdentifier()))
				tn.getNonTreeConnections().add((TarjanNode) graph.getNodeByIdentifier(n.getIdentifier()));
		}
		return tn;
	}

	public TarjanNode getRoot() {
		return root;
	}

	public IGraph getGraph() {
		return graph;
	}

	public void setRoot(TarjanNode root) {
		this.root = root;
	}

	public static void main(String[] args) {
		Set<String> ss = new HashSet<String>();
		String s1 = "saci";
		String s2 = "sacii";
		ss.add(s1);
		System.out.println(ss.contains(s2));
	}
}
