package dfatool.strategy.graph;

import java.util.ArrayList;
import java.util.List;


public class TarjanNode implements INode{
	
	Integer number;
	NodeIdentifier identifier;
//	List<TarjanNode> connections;
	List<TarjanNode> treeConnections;
	List<TarjanNode> nonTreeConnections;
	int ND;
	int L;
	int H;
	
	public TarjanNode(NodeIdentifier identifier) {
		this.identifier = identifier;
//		this.connections = new ArrayList<TarjanNode>();
		this.nonTreeConnections = new ArrayList<TarjanNode>();
		this.treeConnections = new ArrayList<TarjanNode>();
	}

	public int getND() {
		return ND;
	}

	public void setND(int nD) {
		ND = nD;
	}

	public int getL() {
		return L;
	}

	public void setL(int l) {
		L = l;
	}

	public int getH() {
		return H;
	}

	public void setH(int h) {
		H = h;
	}



	public List<TarjanNode> getTreeConnections() {
		return treeConnections;
	}

	public void setTreeConnections(List<TarjanNode> treeConnections) {
		this.treeConnections = treeConnections;
	}

	public List<TarjanNode> getNonTreeConnections() {
		return nonTreeConnections;
	}

	public void setNonTreeConnections(List<TarjanNode> nonTreeConnections) {
		this.nonTreeConnections = nonTreeConnections;
	}

	public void setNumber(Integer number) {
		this.number = number;
	}

	public Integer getNumber() {
		return number;
	}

	public NodeIdentifier getIdentifier() {
		return identifier;
	}

	public void setIdentifier(NodeIdentifier identifier) {
		this.identifier = identifier;
	}
	
	@Override
	public String toString() {
		String print = "TarjanNode: Number "+number+" Identifier"+identifier+"\n TreeConnections: ";
		for(TarjanNode con : treeConnections){
			print += con.getNumber()+ ",";
		}
		print += "\n NonTreeConn: ";
		for(TarjanNode con : nonTreeConnections){
			print += con.getNumber()+ ",";
		}
		return print;
	}

	@Override
	public List<INode> getConnections() {
		// TODO Auto-generated method stub
		return null;
	}
	
}
