package dfatool.views;


import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.*;

import dfatool.strategy.elements.Atom;
import dfatool.strategy.elements.Channel;
import dfatool.strategy.elements.Configuration;
import dfatool.strategy.elements.Datatype;
import dfatool.strategy.elements.Description;
import dfatool.strategy.elements.NamedElement;
import dfatool.strategy.graph.CommunicationGraph;


public class ChannelInfo extends InfoView {


	/**
	 * The ID of the view as specified by the extension.
	 */
	public static final String ID = "dfatool.views.ChannelInfo";

	@Override
	protected void buttonAction(){
		try{
			Channel c = new Channel(fields.get("name").getText(), fields.get("type").getText());
			Configuration.getInstance().getDescription().updateChannel(c);
			Configuration.getInstance().getContext().updateContext();
			CommunicationGraph.getInstance().reInit();
			IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
			DescriptionList view = (DescriptionList) page.findView(DescriptionList.ID);
			view.refresh();
		}catch(Exception e){
			MessageDialog.openError(this.getSite().getShell(), "Error", e.getMessage());
		}
	}


	@Override
	public Map<String, Integer> createFields() {
		HashMap<String, Integer> map = new HashMap<String,Integer>();
		map.put("name", SWT.SINGLE | SWT.BORDER);
		map.put("type", SWT.MULTI | SWT.BORDER);
		return map;
	}

	@Override
	protected void updateView(Object element) {
		if(element instanceof Channel){
			Channel c = (Channel) element;
			fields.get("name").setText(c.getName());
			fields.get("type").setText(c.getType());
		}
		
	}
	
	
}