package dfatool.views;


import java.util.HashMap;
import java.util.Map;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

import dfatool.strategy.elements.Configuration;
import dfatool.strategy.elements.Datatype;
import dfatool.strategy.elements.Description;
import dfatool.strategy.elements.NamedElement;
import dfatool.strategy.graph.CommunicationGraph;


public class DatatypeInfo extends InfoView {


	/**
	 * The ID of the view as specified by the extension.
	 */
	public static final String ID = "dfatool.views.DatatypeInfo";

	@Override
	protected void buttonAction(){
		try{
			Datatype d = new Datatype(fields.get("name").getText(), fields.get("type").getText());
			Configuration.getInstance().getDescription().updateDatatype(d);
			Configuration.getInstance().getContext().updateContext();
			CommunicationGraph.getInstance().reInit();
			IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
			DescriptionList view = (DescriptionList) page.findView(DescriptionList.ID);
			view.refresh();
		}catch(Exception e){
			MessageDialog.openError(this.getSite().getShell(), "Error", e.getMessage());
		}
	}

	
	


	@Override
	public Map<String, Integer> createFields() {
		HashMap<String, Integer> map = new HashMap<String,Integer>();
		map.put("name", SWT.SINGLE | SWT.BORDER);
		map.put("type", SWT.MULTI | SWT.BORDER);
		return map;
	}

	@Override
	protected void updateView(Object element) {
		if(element instanceof Datatype){
			Datatype d = (Datatype) element;
			fields.get("name").setText(d.getName());
			fields.get("type").setText(d.getType());
		}
		
	}
	
	
}