package dfatool.views;


import java.util.HashMap;
import java.util.Map;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.ui.handlers.HandlerUtil;

import dfatool.strategy.verification.ResourceAllocationAdherence;
import dfatool.strategy.verification.Strategy;
import dfatool.strategy.verification.elements.EssentialComponent;
import dfatool.strategy.verification.elements.EssentialComponents;
import dfatool.views.dialogs.DefaultMessageDialog;
import dfatool.views.dialogs.ResourceAllocationDescriptionCreationDialog;


public class EssentialComponentInfo extends InfoView {


	/**
	 * The ID of the view as specified by the extension.
	 */
	public static final String ID = "dfatool.views.EssentialComponentInfo";
	EssentialComponent selectedEssentialComponent;
	
	@Override
	protected void buttonAction(){
		//Create RAD
		ResourceAllocationDescriptionCreationDialog dialog = new ResourceAllocationDescriptionCreationDialog(getSite());
		int returnCode = dialog.open();
		if(returnCode == Window.OK){
			try{
				ResourceAllocationAdherence raa = new ResourceAllocationAdherence(selectedEssentialComponent, dialog.getResourceAllocationDescription());
				boolean success = raa.verifyAdherence();
				if(success){
					EssentialComponents.getInstance().getEssentialComponents().remove(selectedEssentialComponent);
					DefaultMessageDialog.createMessageDialog(getSite().getShell(), 
							"Resource allocation adherence",
							"The essential component "+selectedEssentialComponent.getName()+ 
							" adheres to the resource allocation pattern!").open();
					Strategy.verifyDeadlockFreedomOfNetwork(getSite().getShell());
				}
			}catch(Exception e){
				MessageDialog.openError(this.getSite().getShell(), "Error", e.getMessage());
			}
		}
		
	}


	@Override
	public Map<String, Integer> createFields() {
		this.bName = "Apply resource allocation";
		HashMap<String, Integer> map = new HashMap<String,Integer>();
		map.put("Name", SWT.SINGLE | SWT.BORDER);
		map.put("Elements", SWT.MULTI | SWT.BORDER);
		return map;
	}

	@Override
	protected void updateView(Object element) {
		if(element instanceof EssentialComponent){
			EssentialComponent ec = (EssentialComponent) element;
			fields.get("Name").setText(ec.getName());
			fields.get("Elements").setText(ec.toConcreteSyntax());
			selectedEssentialComponent = ec;
		}
		
	}
	
	
	
	
}