package dfatool.views;


import java.util.ArrayList;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

import patterns.Observer;
import dfatool.strategy.elements.Atom;
import dfatool.strategy.elements.Channel;
import dfatool.strategy.elements.Configuration;
import dfatool.strategy.elements.Datatype;
import dfatool.strategy.elements.Description;
import dfatool.strategy.elements.NamedElement;
import dfatool.strategy.elements.Var;
import dfatool.strategy.verification.elements.EssentialComponent;
import dfatool.strategy.verification.elements.EssentialComponents;
import dfatool.views.dialogs.AtomCreationDialog;
import dfatool.views.dialogs.ChannelCreationDialog;
import dfatool.views.dialogs.DatatypeCreationDialog;
import dfatool.views.dialogs.NetworkElementCreationDialog;
import dfatool.views.dialogs.VarCreationDialog;



public class EssentialComponentsList extends ViewPart{

	/**
	 * The ID of the view as specified by the extension.
	 */
	
	public static final String ID = "dfatool.views.EssentialComponentsList";

	private ListViewer viewer;
	
	private EssentialComponent selection;

	private IAction refresh;
	 
	class ViewContentProvider implements IStructuredContentProvider {

		@Override
		public void dispose() {
			// TODO Auto-generated method stub
			
		}
		@Override
		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
			// TODO Auto-generated method stub
			
		}
		@Override
		public Object[] getElements(Object inputElement) {
			if(inputElement == null)
				return new ArrayList<Object>().toArray();
			EssentialComponents comps =  (EssentialComponents) inputElement;
			if(comps.getEssentialComponents() == null)
				return new ArrayList<Object>().toArray();
			Object[] a = comps.getEssentialComponents().toArray();
			return a;
		}
	}
	
	class ViewLabelProvider extends LabelProvider implements ILabelProvider {
		public String getText(Object obj, int index) {
			return ((EssentialComponent) obj).getName();
		}
	}

	/**
	 * The constructor.
	 */
	public EssentialComponentsList() {
	}

	/**
	 * This is a callback that will allow us
	 * to create the viewer and initialize it.
	 */

	
	public void createPartControl(Composite parent) {

		//Create gui
		viewer = new ListViewer(parent);
		viewer.setContentProvider(new ViewContentProvider());
		viewer.setLabelProvider(new ViewLabelProvider());

		getSite().setSelectionProvider(viewer);
		// Create the help context id for the viewer's control
		makeActions();
		contributeToActionBars();
		hookSelectAction();
		refresh();
	}
	
	private void contributeToActionBars() {
		IActionBars bars = getViewSite().getActionBars();
		fillLocalToolBar(bars.getToolBarManager());
	}


	private void fillLocalToolBar(IToolBarManager manager) {
		manager.add(refresh);
	}

	private void makeActions() {
		refresh = new Action() {
			public void run() {
				viewer.refresh();
			}
		};
		refresh.setText("Refresh");
		refresh.setToolTipText("Refresh view");
		
	}

	
	private void hookSelectAction() {
		viewer.addSelectionChangedListener(new ISelectionChangedListener() {
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				selection = ((EssentialComponent)((StructuredSelection) event.getSelection()).getFirstElement());
				displayAndUpdateEditionView(EssentialComponentInfo.ID, selection);
			}
		});
	}
	
	private void displayAndUpdateEditionView(String viewId, EssentialComponent element){
		System.out.println("Display and Update: viewId"+viewId+ " NamedElement "+ element.getName());
		IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
		EssentialComponentInfo view = (EssentialComponentInfo) page.findView(viewId);
		page.activate(view);
		view.updateView(element);
	}


	/**
	 * Passing the focus request to the viewer's control.
	 */
	public void setFocus() {
		viewer.getControl().setFocus();
	}
	
	public void refresh(){
		if(EssentialComponents.getInstance() != null) viewer.setInput(EssentialComponents.getInstance());
		viewer.refresh();

	}


	@Override
	public void dispose() {
		super.dispose();
	}
}