package dfatool.views;


import java.util.HashMap;
import java.util.Map;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

import dfatool.strategy.elements.NamedElement;


public abstract class InfoView extends ViewPart{

	/**
	 * The ID of the view as specified by the extension.
	 */
	Map<String,Text> fields;
	String bName = "Update";
//	private ISelectionListener listener;
	
	@Override
	public void createPartControl(Composite parent) {
		fields = new HashMap<String, Text>();
		GridLayout gLayout = new GridLayout(2,false);
		gLayout.horizontalSpacing = 10;
		gLayout.verticalSpacing = 20;
		parent.setLayout(gLayout);
//		parent.setSize(500,300);
		Map<String,Integer> map = createFields();
		for(String l : map.keySet()){
			new Label(parent, SWT.NONE).setText(l);
			fields.put(l, new Text(parent, map.get(l)));
			GridData gd = new GridData(SWT.FILL,SWT.FILL,true,true);
			if (map.get(l) == SWT.MULTI)
				gd.verticalSpan = 2;
			fields.get(l).setLayoutData(gd);
		}
		Button bUpdate = new Button(parent, SWT.PUSH);
		bUpdate.setText(bName);
		bUpdate.addListener(SWT.Selection, new Listener() {
		      public void handleEvent(Event e) {
		        switch (e.type) {
		        case SWT.Selection:
		        	buttonAction();
		        	break;
		        }
		      }
		    });
		
	}
	
	@Override
	public void dispose() {
		super.dispose();
	}

	public abstract Map<String, Integer> createFields();

	protected abstract void updateView(Object element);
	
	protected abstract void buttonAction();

	@Override
	public void setFocus() {
		
	}


}