package dfatool.views;


import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.*;

import dfatool.strategy.elements.Atom;
import dfatool.strategy.elements.Channel;
import dfatool.strategy.elements.Configuration;
import dfatool.strategy.elements.Datatype;
import dfatool.strategy.elements.Description;
import dfatool.strategy.elements.NamedElement;
import dfatool.strategy.elements.Network;
import dfatool.strategy.elements.NetworkElement;
import dfatool.strategy.graph.CommunicationGraph;


public class NetworkElementInfo extends InfoView {


	/**
	 * The ID of the view as specified by the extension.
	 */
	public static final String ID = "dfatool.views.NetworkElementInfo";

	@Override
	protected void buttonAction(){
		try{	
			NetworkElement c = new NetworkElement(fields.get("Name").getText(), fields.get("Expression").getText());
			Configuration.getInstance().getNetwork().updateElement(c);
			CommunicationGraph.getInstance().reInit();
			IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
			NetworkList view = (NetworkList) page.findView(NetworkList.ID);
			view.refresh();
		}catch(Exception e){
			MessageDialog.openError(this.getSite().getShell(), "Error", e.getMessage());
		}
	}

	@Override
	public Map<String, Integer> createFields() {
		HashMap<String, Integer> map = new HashMap<String,Integer>();
		map.put("Name", SWT.SINGLE | SWT.BORDER);
		map.put("Expression", SWT.MULTI | SWT.BORDER);
		return map;
	}

	@Override
	protected void updateView(Object element) {
		if(element instanceof NetworkElement){
			NetworkElement ne = (NetworkElement) element;
			fields.get("Name").setText(ne.getName());
			fields.get("Expression").setText(ne.getExpression());
		}
		
	}
	
	
}