package dfatool.views;


import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

import patterns.Observer;
import dfatool.strategy.elements.Atom;
import dfatool.strategy.elements.Channel;
import dfatool.strategy.elements.Configuration;
import dfatool.strategy.elements.Datatype;
import dfatool.strategy.elements.NamedElement;
import dfatool.strategy.elements.Network;
import dfatool.strategy.elements.NetworkElement;
import dfatool.strategy.elements.Var;
import dfatool.views.dialogs.AtomCreationDialog;
import dfatool.views.dialogs.NetworkElementCreationDialog;



public class NetworkList extends ViewPart {

	/**
	 * The ID of the view as specified by the extension.
	 */
	NamedElement selectedElement;
	
	public static final String ID = "dfatool.views.NetworkList";

	private ListViewer viewer;
	private Action addNetworkElement;

	private Action refresh;

	 
	class ViewContentProvider implements IStructuredContentProvider {

		@Override
		public void dispose() {
			// TODO Auto-generated method stub
			
		}
		@Override
		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
			// TODO Auto-generated method stub
			
		}
		@Override
		public Object[] getElements(Object inputElement) {
			Network network = (Network) inputElement;
			Object[] a = network.getList().toArray();
			return a;
		}
	}
	
	class ViewLabelProvider extends LabelProvider implements ILabelProvider {
		public String getText(Object obj, int index) {
			return getText(obj);
		}
	}

	/**
	 * The constructor.
	 */
	public NetworkList() {
	}

	/**
	 * This is a callback that will allow us
	 * to create the viewer and initialize it.
	 */
	public void createPartControl(Composite parent) {
		viewer = new ListViewer(parent);
		viewer.setContentProvider(new ViewContentProvider());
		viewer.setLabelProvider(new ViewLabelProvider());
//		if(Configuration.getInstance() != null) viewer.setInput(Configuration.getInstance().getNetwork());

		getSite().setSelectionProvider(viewer);
		makeActions();
		hookSelectAction();
		contributeToActionBars();
		refresh();
	}
	

	private void contributeToActionBars() {
		IActionBars bars = getViewSite().getActionBars();
		fillLocalToolBar(bars.getToolBarManager());
	}


	private void fillLocalToolBar(IToolBarManager manager) {
		manager.add(refresh);
		manager.add(addNetworkElement);
	}

	private void makeActions() {
		refresh = new Action() {
			public void run() {
				viewer.refresh();
			}
		};
		refresh.setText("Refresh");
		refresh.setToolTipText("Refresh view");
		
		addNetworkElement = new Action() {
			public void run() {
				new NetworkElementCreationDialog(getViewSite()).open();
				viewer.refresh();
			}
		};
		addNetworkElement.setText("+NetEl");
		addNetworkElement.setToolTipText("Add new Network element");
	}

	
	private void hookSelectAction() {
		viewer.addSelectionChangedListener(new ISelectionChangedListener() {
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				NamedElement selectedElement = ((NamedElement)((StructuredSelection) event.getSelection()).getFirstElement());
				String viewId = null;
				if(selectedElement instanceof NetworkElement)
					viewId = NetworkElementInfo.ID;
				if(viewId != null)
					displayAndUpdateEditionView(viewId, selectedElement);
			}
		});
	}
	
	private void displayAndUpdateEditionView(String viewId, NamedElement element){
		System.out.println("Display and Update: viewId"+viewId+ " NamedElement "+ element.getName());
		IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
		InfoView view = (InfoView) page.findView(viewId);
		page.activate(view);
		view.updateView(element);
	}

	/**
	 * Passing the focus request to the viewer's control.
	 */
	public void setFocus() {
		viewer.getControl().setFocus();
	}
	
	public void refresh(){	
		if(Configuration.getInstance() != null) viewer.setInput(Configuration.getInstance().getNetwork());
		viewer.refresh();
	
	}
	
	@Override
	public void dispose() {
		super.dispose();
	}

}