package dfatool.views;


import java.util.HashMap;
import java.util.Map;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

import dfatool.strategy.elements.Configuration;
import dfatool.strategy.elements.Var;
import dfatool.strategy.graph.CommunicationGraph;


public class VarInfo extends InfoView {


	/**
	 * The ID of the view as specified by the extension.
	 */
	public static final String ID = "dfatool.views.VarInfo";

	@Override
	protected void buttonAction(){
		try{
			Var v = new Var(fields.get("name").getText(), fields.get("value").getText());
			Configuration.getInstance().getDescription().updateVar(v);
			Configuration.getInstance().getContext().updateContext();
			CommunicationGraph.getInstance().reInit();
			IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
			DescriptionList view = (DescriptionList) page.findView(DescriptionList.ID);
			view.refresh();
		}catch(Exception e){
			MessageDialog.openError(this.getSite().getShell(), "Error", e.getMessage());
		}
	}

	@Override
	public Map<String, Integer> createFields() {
		HashMap<String, Integer> map = new HashMap<String,Integer>();
		map.put("name", SWT.SINGLE | SWT.BORDER);
		map.put("value", SWT.MULTI | SWT.BORDER);
		return map;
	}

	@Override
	protected void updateView(Object element) {
		if(element instanceof Var){
			Var v = (Var) element;
			fields.get("name").setText(v.getName());
			fields.get("value").setText(v.getValue());
		}
		
	}
	
	
}