package dfatool.views.dialogs;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.SWT;

import dfatool.strategy.elements.Atom;
import dfatool.strategy.elements.Configuration;
import dfatool.strategy.elements.Description;

public class AtomCreationDialog extends CreationDialog{

	public AtomCreationDialog(IShellProvider parentShell) {
		super(parentShell);
	}
	
	@Override
	protected void okPressed() {
		try {
			String name = this.fields.get("Name").getText();
			String alphabet = this.fields.get("Alphabet").getText();
			String behaviour = this.fields.get("Behaviour").getText();
			Atom a = new Atom(name,behaviour,alphabet);
			Configuration.getInstance().getDescription().updateAtom(a);
		}catch (Exception e){
			MessageDialog.openError(this.getParentShell(), "Error", e.getMessage());
		}finally{
			this.close();
		}
	}

	@Override
	protected Map<String, Integer> createFields() {
		HashMap<String, Integer> map = new HashMap<String,Integer>();
		map.put("Name", SWT.SINGLE | SWT.BORDER);
		map.put("Behaviour", SWT.MULTI | SWT.BORDER);
		map.put("Alphabet", SWT.MULTI | SWT.BORDER);
		return map;
	}

}
