package dfatool.views.dialogs;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.SWT;

import dfatool.strategy.elements.Atom;
import dfatool.strategy.elements.Channel;
import dfatool.strategy.elements.Configuration;
import dfatool.strategy.elements.Description;

public class ChannelCreationDialog extends CreationDialog{

	public ChannelCreationDialog(IShellProvider parentShell) {
		super(parentShell);
	}
	
	@Override
	protected void okPressed() {
		try{
			String name = this.fields.get("Name").getText();
			String type = this.fields.get("Type").getText();
			Channel c = new Channel(name,type);
			Configuration.getInstance().getDescription().updateChannel(c);
		}catch (Exception e){
			MessageDialog.openError(this.getParentShell(), "Error", e.getMessage());
		}finally{
			this.close();
		}
	}

	@Override
	protected Map<String, Integer> createFields() {
		HashMap<String, Integer> map = new HashMap<String,Integer>();
		map.put("Name", SWT.SINGLE | SWT.BORDER);
		map.put("Type", SWT.MULTI | SWT.BORDER);
		return map;
	}

}
