package dfatool.views.dialogs;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import dfatool.strategy.elements.Atom;
import dfatool.strategy.elements.Description;

public abstract class CreationDialog extends Dialog{

	protected Map<String, Text> fields;

	protected CreationDialog(IShellProvider parentShell) {
		super(parentShell);
	}
	
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite composite = (Composite) super.createDialogArea(parent);
		GridLayout gLayout = new GridLayout(5,false);
		gLayout.horizontalSpacing = 10;
		gLayout.verticalSpacing = 20;
		composite.setLayout(gLayout);
		Map<String,Integer> map = createFields();
		fields = new HashMap<String, Text>();
		for(String l : map.keySet()){
			int vSpan = 1;
			if(map.get(l) == (SWT.MULTI | SWT.BORDER))
				vSpan = 5;
			label(composite, l,vSpan);
			text(composite, map, l, vSpan);
		}
		return composite;
	}

	private void text(Composite composite, Map<String, Integer> map, String l, int vSpan) {
		GridData gd = new GridData();
		gd.horizontalSpan = 4;
		gd.horizontalAlignment = SWT.FILL;
		gd.grabExcessHorizontalSpace = true;
		gd.verticalAlignment = SWT.FILL;
		gd.verticalSpan = vSpan;
		fields.put(l, new Text(composite, map.get(l)));
		fields.get(l).setLayoutData(gd);
	}

	private void label(Composite composite, String name, int vSpan) {
		Label l = new Label(composite, SWT.NONE);
		l.setText(name);
		GridData gd = new GridData();
		gd.verticalSpan = vSpan;
		l.setLayoutData(gd);
	}
	
	@Override
	protected boolean isResizable() {
		return true;
	}
	
	protected abstract Map<String, Integer> createFields() ;


}
