package dfatool.views.dialogs;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.SWT;

import dfatool.strategy.elements.Atom;
import dfatool.strategy.elements.Configuration;
import dfatool.strategy.elements.Datatype;
import dfatool.strategy.elements.Description;

public class DatatypeCreationDialog extends CreationDialog{

	public DatatypeCreationDialog(IShellProvider parentShell) {
		super(parentShell);
	}
	
	@Override
	protected void okPressed() {
		try{
			String name = this.fields.get("Name").getText();
			String type = this.fields.get("Expression").getText();
			Datatype a = new Datatype(name,type);
			Configuration.getInstance().getDescription().updateDatatype(a);
		}catch (Exception e){
			MessageDialog.openError(this.getParentShell(), "Error", e.getMessage());
		}finally{
			this.close();
		}
	}

	@Override
	protected Map<String, Integer> createFields() {
		HashMap<String, Integer> map = new HashMap<String,Integer>();
		map.put("Name", SWT.SINGLE | SWT.BORDER);
		map.put("Expression", SWT.MULTI | SWT.BORDER);
		return map;
	}

}
