package dfatool.views.dialogs;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.SWT;

import dfatool.strategy.elements.Atom;
import dfatool.strategy.elements.Configuration;
import dfatool.strategy.elements.Description;
import dfatool.strategy.elements.Network;
import dfatool.strategy.elements.NetworkElement;

public class NetworkElementCreationDialog extends CreationDialog{

	public NetworkElementCreationDialog(IShellProvider parentShell) {
		super(parentShell);
	}
	
	@Override
	protected void okPressed() {
		try{
			String name = this.fields.get("Atom name").getText();
			String expression = this.fields.get("Expression").getText();
			NetworkElement ne = new NetworkElement(name, expression);
			Configuration.getInstance().getNetwork().updateElement(ne);
		}catch (Exception e){
			MessageDialog.openError(this.getParentShell(), "Error", e.getMessage());
		}finally{
			this.close();
		}
	}

	@Override
	protected Map<String, Integer> createFields() {
		HashMap<String, Integer> map = new HashMap<String,Integer>();
		map.put("Atom name", SWT.SINGLE | SWT.BORDER);
		map.put("Expression", SWT.MULTI | SWT.BORDER);
		return map;
	}

}
