package dfatool.views.graph;

import org.eclipse.zest.core.viewers.EntityConnectionData;
import org.eclipse.jface.viewers.LabelProvider;

import dfatool.strategy.graph.NetworkNode;

public class NodesLabelProvider extends LabelProvider {
	  @Override
	  public String getText(Object element) {
	    if (element instanceof NetworkNode) {
	    	NetworkNode myNode = (NetworkNode) element;
	    	return myNode.getAtomName()+"."+myNode.getNumber();
	    }
	    // Not called with the IGraphEntityContentProvider
	    

	    if (element instanceof EntityConnectionData) {
	      EntityConnectionData test = (EntityConnectionData) element;
	      return "";
	    }
	    throw new RuntimeException("Wrong type: "
	        + element.getClass().toString());
	  }
	
}
