package patterns;

import java.util.ArrayList;
import java.util.List;

public abstract class Subject {
	
	private List<Observer> observers;
	
	public void register(Observer observer){
		if(observers == null){
			observers = new ArrayList<Observer>();
		}
		observers.add(observer);
	}
	
	public void unregister(Observer observer){
		if(observers == null){
			return;
		}
		observers.remove(observer);
	}
	
	public void alertAll(){
		if(observers == null) return;
		for(Observer observer: observers){
			System.out.println("Update: "+ observer);
			observer.update();
		}
	}

}
