'''
Created on 4 Jun 2015

@author: pedroribeiro
'''
import os
import time
import operator

def sortFile(file):
    keys = []
    with open(file,"r") as f:
        lines = f.readlines();
        keys = [ (l.split(' ')[0],l) for l in lines]
        keys = sorted(keys, key=operator.itemgetter(0))
        f.close()
        
    with open(file,"w") as f:
        for (k,l) in keys:
            f.write(l)
        f.close()
            

def sortFileNew(file):
    keys = []
    with open(file,"r") as f:
        lines = f.readlines();
        keys = [ (l.split(' ')[0],int(l.split(' ')[1][1:]),l) for l in lines]
        keys = sorted(keys, key=operator.itemgetter(0,1))
        f.close()
        
    with open(file,"w") as f:
        for (_,_,l) in keys:
            f.write(l)
        f.close()

def experimentData(results_folder):
    table = {}
    summary = {}
    for method_name in os.listdir(results_folder):
        if (not os.path.isdir(os.path.join(results_folder,method_name))):
            continue
            table[method_name] = {}
            n_passed = 0
            n_timeouts = 0
        for example_name in os.listdir(os.path.join(results_folder,method_name)):
            if (not os.path.isdir(os.path.join(results_folder,method_name,example_name))):
                continue
            table[method_name][example_name] = {}
            for n in os.listdir(os.path.join(results_folder,method_name,example_name)):
                if (not os.path.isdir(os.path.join(results_folder,method_name,example_name,n))):
                    continue
                for filename in os.listdir(os.path.join(results_folder,method_name,example_name,n)):
                    f = open(os.path.join(results_folder,method_name,example_name,n,filename),"r")
                    valid = False;
                    for s in f.readlines():
                        if(s.find("Passed") != -1):
                            n_passed = n_passed+1
                            valid = True
                            break
                        elif(s.find("Failed") != -1):
                            valid = True
                            break
                        elif(s.find("TIMEOUT") != -1):
                            n_timeouts = n_timeouts + 1
                            valid = True
                            break
                    assert valid
                    
        for method_name in table.keys()
        
    sortFile(os.path.join(results_folder,"summary_accuracy"))
    sortFile(os.path.join(results_folder,"summary_time"))
    
def invariantsInfo(results_folder):
    summary_file = open(os.path.join(results_folder,"summary_invariants"),"w")
    for dir_name in os.listdir(results_folder):
        if (not os.path.isdir(os.path.join(results_folder,dir_name))):
            continue
        for filename in os.listdir(os.path.join(results_folder,dir_name)):
            f = open(os.path.join(results_folder,dir_name,filename),"r")
            for s in f.readlines():
                if(s.find("Sum") != -1):
                    sum = s.split(' ')
                elif(s.find("Existential") != -1):
                    exs = s.split(' ')       
                    
            summary_file.write(dir_name+" Sum "+sum[1]+" "+sum[5].rstrip()+" Exs "+exs[1]+" "+exs[5].rstrip()+" \n")
        
        
    summary_file.close()
        
    sortFile(os.path.join(results_folder,"summary_invariants"))

def getTime(method, name, n):
    f = open("ResultsBenchmark/"+method+"/summary_time","r")
    for s in f.readlines():
        if(s.find(name) != -1 and s.find("N"+str(n)) != -1):
            return float(s.split(' ')[2])
            
    return 0
    
def generateTable(results_top_folder):
    method_names = ["Static", "CSDD", "FSDD", "FDR_COMPRESSED", "FDR_POR", "FDR"]
    sortFileNew("ResultsBenchmark/Static/summary_time")
    static_accurary_file = open("ResultsBenchmark/Static/summary_time","r")
    table = open("table.txt","w")
    for s in static_accurary_file.readlines():
        words = s.split(' ')
        name= words[0]
        n = words[1][1:]
        table.write(name +" \t\t& "+n+" \t\t")
        for method in method_names:
            table.write("& " + str(round(getTime(method, name, n),2))+" \t\t")
            
        table.write(" \\\\\n")
        
        
if __name__ == '__main__':
    
    experimentData("Experiments")
        
        

    
    
