'''
Created on 4 Jun 2015

@author: pedroribeiro
'''
import os
import time
import subprocess
import shutil
import threading
import Conf
from signal import SIGKILL
# from sys import stderr

class Command(object):
    def __init__(self, cmd, log, cwd=None):
        self.cmd = cmd
        self.log = log
        self.cwd = cwd
        self.process = None

    def run(self, timeout = Conf.TIMEOUT):
        def tgt():
	    print "Command" + str(self.cmd)
            self.process = subprocess.Popen(self.cmd,cwd=self.cwd,stdout=self.log,stderr=subprocess.STDOUT, preexec_fn=os.setsid)
            self.process.communicate()

        thread = threading.Thread(target=tgt)
        thread.start()

        thread.join(timeout)
        if thread.is_alive():
            print 'Terminating process'
            try:
                os.killpg(os.getpgid(self.process.pid), SIGKILL)
            except OSError:
                print "============== OSError killing a process"
            thread.join()
            self.log.write("TIMEOUT\n")
            return -1
        return self.process.returncode
        

def FDR2_COMMAND(script,log):
    return Command([Conf.FDR2_HOME+"/bin/fdr2", "batch", script], log).run()

def SDD_COMMAND(script,log):
    return DC_COMMAND(script,log, "SDD")
        
def DC_COMMAND(script,log, method="ALL"):
    print "Executing "+script+" \n"
    os.environ['FDRHOME'] = Conf.FDR2_HOME
    FNULL = open(os.devnull, 'w')
    #COMPRESSION_FILE_PATH = os.path.join(os.path.dirname(script),"compression.csp")
    #shutil.copy("Templates/compression.csp", COMPRESSION_FILE_PATH)
    with open("go.tcl","w") as f: 
        f.write("source compile.tcl; compile "+script+" SYSTEM Net.net")
        f.close()
    
    
    if Command([Conf.FDR2_HOME+"/bin/fdr2tix", "-insecure", "-nowindow", "go.tcl"], FNULL).run() == -1:
        FNULL.close()
        log.write("TIMEOUT\n")
        os.remove("go.tcl")
        log.close()
        return False
    FNULL.close()
    
    ret = Command(["java", "-cp", Conf.DEADLOCK_CHECKER_HOME, "Deadlock.CommandLine", method, "Net.net"],log).run()
            
    if(ret == 0):
        log.write("true \n")
    else:
        log.write("false \n")
#     os.remove("go.tcl")
    os.remove("Net.net")
    return ret

    
    
