'''
Created on 22 Sep 2015

@author: pedroribeiro
'''

import Execute, os
import time
import Conf
from Execute import FDR2_COMMAND, SDD_COMMAND
    
    
def run(folder,technique_name,command,scripts):
    log = open(folder+"log_"+technique_name+".txt","w")
    initial_time = time.time()
    print scripts
    for script in scripts:
        command(folder+script,log)
    final_time = time.time()
    log.close()
    result = check_result(folder+"log_"+technique_name+".txt")
    summary = open(folder+"summary_"+technique_name+".txt","w")
    summary.write(str(result)+" "+str(final_time-initial_time))
    summary.close()
    
def scriptsRB(n):
    return ["Conflict_Controller.0_RingCell."+str(i)+".csp" for i in range(n)]
    
def check_result(log_filename):
    f = open(log_filename,"r")
    for s in f.readlines():
        if(s.find("false") != -1):
            f.close()
            return "failed"
        elif(s.find("TIMEOUT") != -1):
            f.close()
            return "timeout"
        elif s.find("error") != -1 or s.find("Error") != -1 or s.find("ERROR") != -1:
            f.close()
            return "error"
    return "passed"
    
def myformat(n_char,text): return ("{:<"+str(n_char)+"}").format(text)
def myflot(text): return "{:.2f}".format(text)

def summary(folder,technique_name):
    print folder + technique_name
    summ = get_summary(folder, technique_name)
    if summ[0] == "passed":
        return myflot(float(summ[1]))
    elif summ[0] == "failed":
        return "-"
    elif summ[0] == "timeout":
        return "*"
    elif summ[0] == "error":
        return "e"
    else:
        assert False

def get_summary(folder,technique_name):
    summary_file = open(folder+"summary_"+technique_name+".txt","r")
    result = summary_file.readline().split(" ")
    print result
    summary_file.close()
    return result

if __name__ == '__main__':
    
    RBR = [3,5,10,20,30]
    DPR = [5,10,50,100,200]
    LER = [3,5,10,20,30]
    os.environ['FDRHOME'] = Conf.FDR2_HOME
    
#     for n in RBR:
#         run("scripts/RB"+str(n)+"/","DFA",FDR2_COMMAND,scriptsRB(n))
#         run("scripts/RB"+str(n)+"/","SDD",SDD_COMMAND, ["VerificationFDR2.csp"])
#         run("scripts/RB"+str(n)+"/","FDR2",FDR2_COMMAND, ["VerificationFDR2.csp"])
#         run("scripts/RB"+str(n)+"/","FDR2c",FDR2_COMMAND, ["VerificationFDR2c.csp"])
#          
#    for n in DPR:
#        run("scripts/DP"+str(n)+"/","DFA",FDR2_COMMAND,["ResourceAllocationVerificationEC0.csp"])
#        run("scripts/DP"+str(n)+"/","SDD",SDD_COMMAND, ["VerificationFDR2.csp"])
#        run("scripts/DP"+str(n)+"/","FDR2",FDR2_COMMAND, ["VerificationFDR2.csp"])
#        run("scripts/DP"+str(n)+"/","FDR2c",FDR2_COMMAND, ["VerificationFDR2c.csp"])
#          
#     for n in LER:
#         run("scripts/LE"+str(n)+"/","DFAte",FDR2_COMMAND,["LOCAL_TE.csp"])
#         run("scripts/LE"+str(n)+"/","DFAp",FDR2_COMMAND,["LOCAL_P.csp"])
#         run("scripts/LE"+str(n)+"/","SDD",SDD_COMMAND, ["VerificationFDR2.csp"])
#         run("scripts/LE"+str(n)+"/","FDR2",FDR2_COMMAND, ["VerificationFDR2.csp"])
        
        
    table_rb = open("table_rb.txt","w")
    table_rb.write(myformat(6, "N"))
    table_rb.write(myformat(12, "& DFA"))
    table_rb.write(myformat(12, "& SDD"))
    table_rb.write(myformat(12, "& FDR2"))
    table_rb.write(myformat(12, "& FDR2c"))
    table_rb.write("\\\\ \n")
     
    for n in RBR:
        table_rb.write("\\hline \n")
        table_rb.write(myformat(6, str(n)))
        table_rb.write(myformat(12,"& "+summary("scripts/RB"+str(n)+"/","DFA")))
        table_rb.write(myformat(12,"& "+summary("scripts/RB"+str(n)+"/","SDD")))
        table_rb.write(myformat(12,"& "+summary("scripts/RB"+str(n)+"/","FDR2")))
        table_rb.write(myformat(12,"& "+summary("scripts/RB"+str(n)+"/","FDR2c")))
        table_rb.write("\\\\ \n")
         
    table_rb.close()
     
    table_dp = open("table_dp.txt","w")
    table_dp.write(myformat(6, "N"))
    table_dp.write(myformat(12, "& DFA"))
    table_dp.write(myformat(12, "& SDD"))
    table_dp.write(myformat(12, "& FDR2"))
    table_dp.write(myformat(12, "& FDR2c"))
    table_dp.write("\n")
         
         
    for n in DPR:
        table_dp.write("\\hline \n")
        table_dp.write(myformat(6, str(n)))
        table_dp.write(myformat(12,"& "+summary("scripts/DP"+str(n)+"/","DFA")))
        table_dp.write(myformat(12,"& "+summary("scripts/DP"+str(n)+"/","SDD")))
        table_dp.write(myformat(12,"& "+summary("scripts/DP"+str(n)+"/","FDR2")))
        table_dp.write(myformat(12,"& "+summary("scripts/DP"+str(n)+"/","FDR2c")))
        table_dp.write("\\\\ \n")
         
    table_dp.close()
     
    table_le = open("table_le.txt","w")
    table_le.write(myformat(6, "N"))
    table_le.write(myformat(12, "& DFA"))
    table_le.write(myformat(12, "& SDD"))
    table_le.write(myformat(12, "& FDR2"))
    table_le.write(myformat(12, "& FDR2c"))
    table_le.write("\\\\ \n")
         
    for n in LER:
        table_le.write("\\hline \n")
        table_le.write(myformat(6, str(n)))
        summ_dfap = get_summary("scripts/LE"+str(n)+"/","DFAp")
        summ_dfate = get_summary("scripts/LE"+str(n)+"/","DFAte")
        summ_dfa = ""
        if summ_dfap[0] == "timeout" or summ_dfate[0] == "timeout": 
            summ_dfa = "*"
        elif summ_dfap[0] == "failed" or summ_dfate[0] == "failed":
            summ_dfa = "-"
        elif summ_dfap[0] == "passed" and summ_dfate[0] == "passed":
            summ_dfa = myflot(n*float(summ_dfap[1])+(n*(n-1)/2)*float(summ_dfate[1]))
        else:
            assert False
        table_le.write(myformat(12,"& "+summ_dfa))
        table_le.write(myformat(12,"& "+summary("scripts/LE"+str(n)+"/","SDD")))
        table_le.write(myformat(12,"& "+summary("scripts/LE"+str(n)+"/","FDR2")))
        table_le.write(myformat(12,"& +"))
        table_le.write("\\\\ \n")
         
    table_le.close()
        
        
    
        
