'''
Created on 22 Sep 2015

@author: pedroribeiro
'''

from Experiment import Methods
# from Cheetah.Template import Template
# import time
# import Report
# import Conf
# from Conf import DFINDER_HOME

def myformat(n_char,text): return ("{:<"+str(n_char)+"}").format(text)
def myflot(text): return "{:.2f}".format(text)

def example_name(name):
	dic = {"ABP":"ABP",
            "ButIdDis":"ButID",
            "ButIdDis2":"ButID2",
            "ButId":"ButI",
            "Lock":"Lock",
            "Phils":"Phils",
            "Ray":"Ray",
            "SWP":"SWP",
            "Tarry":"Tarry",
            "Tel":"Tel",
            "VirtRoute":"Rout",
	    "RtChainM4":"RtChainM4"}
	if name in dic:
		return dic[name]
	else:
		return name


def method_name(name):
    return {Methods.DFinderPM: "DF2pm",
            Methods.DFinderFP: "DF2fp",
            Methods.DFinderLinear: "DF2l",
            Methods.FDR_C: "FDRc",
            Methods.FDR: "FDR",
            Methods.FDR_POR: "FDRp",
            Methods.SDD: "SDD",
            Methods.FSDD: "FSDD",
            Methods.CSDD: "CSDD",
            Methods.Pair: "P",
            Methods.PairPicking: "PP",
            Methods.PairStatic: "PS",
            Methods.PairStaticSMT: "PSsmt",
            Methods.PairToken: "PT",
            Methods.PairTokenSMT: "PTsmt",
	    Methods.Approx: "ApprOx",
	    Methods.ApproxSMT: "ApprOxSMT",
	    Methods.LApprox: "ApprOx",
	    Methods.LApproxSMT: "ApprOxSMT"
            }[name]

def load_table(results_table_filename):
    table = {}
    with open(results_table_filename,"r") as f:
        methods = f.readline().replace("\\","").replace(" ","").replace("\n","").replace("\r","").split('&')
        #print methods
        assert methods[0] == "Example"
        methods.pop(0)
        methods.pop(0)
        #print methods

        for l in f.readlines():
            columns = l.replace("\\","").replace(" ","").replace("\n","").replace("\r","").split('&')
            example = columns.pop(0)
            n = columns.pop(0)
            for (i,v) in enumerate(columns):
                method = methods[i]
                if example not in table:
                    table[example] = {}
                if n not in table[example]:
                    table[example][n] = {}
                table[example][n][method] = v

    #print table
    f.close()
    return table

def create_table(methods, examples, results_table_filename, new_table_filename):
    results_table = load_table(results_table_filename)
    table = open(new_table_filename,"w")
    table.write("\hline ")
    table.write(myformat(14,"Example"))
    table.write(myformat(6,"& N"))

    for method in methods:
        table.write(myformat(14,"& "+method_name(method)))

    table.write(" \\\\\n")
    table.write("\hline ")

    for example in examples:
        first_time = True
        ks = results_table[example].keys()
        ks.sort(key=int)
        for n in ks:
            if first_time:
                first_time = False
                table.write("\multirow{4}{*}{"+example_name(example)+"}\n")
                table.write(myformat(14,""))
            else:
                table.write(myformat(14,""))
            table.write(myformat(6,"& "+str(n)))
            for method in methods:
                table.write(myformat(14,"& "+results_table[example][n][method]))
            table.write(" \\\\\n")
        table.write("\hline ")


    table.close()


if __name__ == '__main__':

    #Pair
    create_table([Methods.SDD, Methods.Pair, Methods.DFinderPM, Methods.DFinderFP, Methods.DFinderLinear,Methods.FDR, Methods.FDR_C, Methods.FDR_POR],
                    ["ABP", "Lock","Phils", "Ray","SWP", "Tarry", "Tel", "VirtRoute"],
                    "results_table_d.txt", "Tables/pair_hereditary_table.txt")
    create_table([Methods.SDD, Methods.Pair, Methods.DFinderPM, Methods.DFinderFP, Methods.DFinderLinear,Methods.FDR, Methods.FDR_C, Methods.FDR_POR],
                    ["ButID","ButID2","ButI"],
                    "results_table_d.txt", "Tables/pair_non_hereditary.txt")

    #PairPicking
    create_table([Methods.PairPicking, Methods.FDR, Methods.FDR_C, Methods.FDR_POR],
                    ["VChain4", "VGrid4", "VFully4","VChain5","VGrid5","VFully5", "VChain6", "VGrid6","VFully6"],
                    "results_table_d.txt", "Tables/pair_picking_majority.txt")
    create_table([Methods.PairPicking,Methods.FDR, Methods.FDR_C, Methods.FDR_POR],
                    ["PChain4","PGrid4","PFully4","PChain5","PGrid5","PFully5","PChain6","PGrid6","PFully6"],
                    "results_table_d.txt", "Tables/pair_picking_priority.txt")

    #PairStatic
    create_table([Methods.FSDD, Methods.CSDD, Methods.PairStatic, Methods.PairStaticSMT, Methods.DFinderPM, Methods.FDR, Methods.FDR_C, Methods.FDR_POR],
                    ["But", "DDB", "HexSys","Mat", "RingP", "Ring", "Sched", "TS", "MVote"],
                    "results_table_d.txt", "Tables/pair_static1.txt")
    create_table([Methods.PairStatic, Methods.PairStaticSMT, Methods.DFinderPM, Methods.DFinderFP, Methods.DFinderLinear,Methods.FDR, Methods.FDR_C, Methods.FDR_POR],
                    ["MsgGrid", "Ring2", "Ring2Hf","Ring2S", "Ring2SHf", "Track", "TrackHf"],
                    "results_table_d.txt", "Tables/pair_static2.txt")
    create_table([Methods.PairStaticSMT, Methods.FDR, Methods.FDR_C, Methods.FDR_POR],
                    ["TkFully", "TkFullyHf", "TkGrid", "TkGridHf", "TkRing", "TkRingHf"],
                    "results_table_d.txt", "Tables/pair_static3.txt")


    #PairToken
    create_table([Methods.FSDD, Methods.CSDD, Methods.PairStatic, Methods.PairStaticSMT, Methods.PairToken, Methods.PairTokenSMT, Methods.FDR, Methods.FDR_C, Methods.FDR_POR],
                    ["But", "DDB", "HexSys","Mat", "RingP", "PQ" , "Ring", "Sched", "MVote"],
                    "results_table_d.txt", "Tables/pair_token1.txt")
    create_table([Methods.PairStatic, Methods.PairStaticSMT, Methods.PairToken, Methods.PairTokenSMT, Methods.DFinderFP, Methods.FDR, Methods.FDR_C, Methods.FDR_POR],
                    ["MsgGrid", "Ring2", "Ring2Hf","Ring2S", "Ring2SHf", "Track", "TrackHf"],
                    "results_table_d.txt", "Tables/pair_token2.txt")
    create_table([Methods.PairStaticSMT, Methods.PairTokenSMT, Methods.FDR, Methods.FDR_C, Methods.FDR_POR],
                    ["TkFully", "TkFullyHf", "TkGrid", "TkGridHf", "TkRing", "TkRingHf"],
                    "results_table_d.txt", "Tables/pair_token3.txt")

    create_table([Methods.PairTokenSMT,  Methods.FDR, Methods.FDR_C, Methods.FDR_POR],
                    ["TkDestFully", "TkDestFullyHf", "TkDestGrid", "TkDestGridHf", "TkDestRing", "TkDestRingHf"],
                    "results_table_d.txt", "Tables/pair_token4.txt")
    create_table([Methods.PairTokenSMT, Methods.FDR, Methods.FDR_C, Methods.FDR_POR],
                    ["Cons", "Cons2", "NonCons", "NonCons10"],
                    "results_table_d.txt", "Tables/pair_token5.txt")

#StaticProperty
    create_table([Methods.Approx, Methods.LApprox, Methods.ApproxSMT, Methods.LApproxSMT, Methods.FSDD, Methods.CSDD, Methods.DFinderPM, Methods.FDR, Methods.FDR_C, Methods.FDR_POR],
                    ["Lock", "Ray", "Tarry", "Rout", "But", "DDB", "Mat"],
                    "results_table_spd.txt", "Tables/spd.txt")
    create_table([Methods.Approx, Methods.LApprox, Methods.ApproxSMT, Methods.LApproxSMT, Methods.FSDD, Methods.CSDD, Methods.DFinderPM, Methods.FDR, Methods.FDR_C, Methods.FDR_POR],
                    ["PQ","RingP", "Ring", "Sched", "Track", "Ring2SHf", "MsgGrid"],
                    "results_table_spd.txt", "Tables/spd2.txt")

    create_table([Methods.Approx, Methods.ApproxSMT, Methods.FDR, Methods.FDR_C, Methods.FDR_POR],
                    ["Lock", "Sched", "RingP", "PQ", "GridTk", "Ray", "RWMutex", "SI"],
                    "results_table_spo.txt", "Tables/spo.txt")
    create_table([Methods.Approx, Methods.ApproxSMT, Methods.FDR, Methods.FDR_C, Methods.FDR_POR],
                    ["PhilP1", "PhilP2", "But", "LiftP1", "LiftP2", "LiftP3", "LB"],
                    "results_table_spo.txt", "Tables/spo2.txt")
#Refinement checking
    create_table([Methods.Approx, Methods.ApproxSMT, Methods.FDR, Methods.FDR_C, Methods.FDR_POR],
                    ["Mem", "CS", "Res", "Rout", "Rout2"],
                    "results_table_rct.txt", "Tables/rct.txt")
    create_table([Methods.Approx, Methods.ApproxSMT, Methods.FDR, Methods.FDR_C, Methods.FDR_POR],
                    ["Lift","Lift2", "Phil", "Phil2", "Ring", "Rot"],
                    "results_table_rct.txt", "Tables/rct2.txt")

    create_table([Methods.Approx, Methods.ApproxSMT, Methods.FDR, Methods.FDR_C, Methods.FDR_POR],
                    ["Mem", "CS", "Res", "Rout", "Rout2"],
                    "results_table_rcf.txt", "Tables/rcf.txt")
    create_table([Methods.Approx, Methods.ApproxSMT, Methods.FDR, Methods.FDR_C, Methods.FDR_POR],
                    ["Lift", "Lift2", "But", "Ring", "Rot"],
                    "results_table_rcf.txt", "Tables/rcf2.txt")


