#include <iostream>
#include <set>
#include <cmath>

#include <solvers/flattening/bv_pointers.h>
#include <util/i2string.h>
#include <solvers/smt2/smt2_dec.h>

#include "incremental_solver.h"
#include "../util/version.h"

void incremental_solvert::new_context() 
{
#ifdef NON_INCREMENTAL
  contexts.push_back(constraintst());

#if 0
  std::cerr << "new context: " << contexts.size() << std::endl;
#endif

#else

  literalt activation_literal = solver->convert(
      symbol_exprt("hasco::\\act$"+
      i2string(activation_literal_counter++), bool_typet()));

#ifdef DEBUG_OUTPUT
    debug() << "new context: " << activation_literal<< eom;
#endif

  activation_literals.push_back(activation_literal);
  solver->set_assumptions(activation_literals);

#if 0
  return !activation_literals.back(); //not to be used anymore
#endif
#endif
}

void incremental_solvert::pop_context() 
{
#ifdef NON_INCREMENTAL
  assert(!contexts.empty());

#if 0
  std::cerr << "pop context: " << contexts.size() << std::endl;
#endif

  contexts.pop_back();

#else

  assert(!activation_literals.empty());
  literalt activation_literal = activation_literals.back();
  activation_literals.pop_back();
#ifndef DEBUG_FORMULA
  solver->set_to_false(literal_exprt(activation_literal));
#else
  formula.push_back(!activation_literal);
#endif

#ifdef DEBUG_OUTPUT
    debug() << "pop context: " << activation_literal << eom;
#endif

  solver->set_assumptions(activation_literals);
#endif
}

void incremental_solvert::make_context_permanent() 
{
#ifdef NON_INCREMENTAL
  assert(contexts.size()>=2);
  contextst::iterator c_it = contexts.end(); c_it--; c_it--;
  c_it->insert(c_it->end(),contexts.back().begin(),contexts.back().end());
  contexts.pop_back();
#else
  assert(!activation_literals.empty());
  literalt activation_literal = activation_literals.back();
  activation_literals.pop_back();
#ifndef DEBUG_FORMULA
  solver->set_to_true(literal_exprt(activation_literal));
#else
  formula.push_back(activation_literal);
#endif

#ifdef DEBUG_OUTPUT
    debug() << "make context permanent: " << activation_literal<< eom;
#endif

  solver->set_assumptions(activation_literals);
#endif
}

void incremental_solvert::debug_add_to_formula(const exprt &expr) 
{
#ifdef NON_INCREMENTAL
  // no debug mode for non-incremental yet
#else
  literalt l = solver->convert(expr);
  if(l.is_false())
  {
#ifdef DEBUG_OUTPUT
    debug() << "literal " << l << ": false = " << from_expr(ns,"",expr) <<eom;
#endif
    literalt dummy = solver->convert(symbol_exprt("goto_symex::\\dummy", 
						 bool_typet()));
    formula.push_back(dummy);
    formula.push_back(!dummy);
#ifdef DEBUG_OUTPUT
    debug() << "literal " << dummy << ", " << !dummy << ": " 
	      << from_expr(ns,"",expr) << eom;
#endif
  }
  else if(!l.is_true()) 
  {
#ifdef DEBUG_OUTPUT
    debug() << "literal " << l << ": " << from_expr(ns,"",expr) << eom;
#endif
    formula.push_back(l);
  }
#endif
}
void incremental_solvert::allocate_solvers()
 {

	if(options.get_bool_option("smt2"))
	{
		smt2_dect::solvert solver_type = get_smt2_solver_type();

		solver = get_smt2(solver_type);

	}
	else
	{
		solver= get_minisat2();
	}
 }
smt2_dect::solvert incremental_solvert::get_smt2_solver_type() const
{
  assert(options.get_bool_option("smt2"));

  smt2_dect::solvert s = smt2_dect::GENERIC;

  if(options.get_bool_option("boolector"))
    s = smt2_dect::BOOLECTOR;
  else if(options.get_bool_option("mathsat"))
    s = smt2_dect::MATHSAT;
  else if(options.get_bool_option("cvc3"))
    s = smt2_dect::CVC3;
  else if(options.get_bool_option("cvc4"))
    s = smt2_dect::CVC4;
  else if(options.get_bool_option("opensmt"))
    s = smt2_dect::OPENSMT;
  else if(options.get_bool_option("yices"))
    s = smt2_dect::YICES;
  else if(options.get_bool_option("z3"))
    s = smt2_dect::Z3;
  else if(options.get_bool_option("generic"))
    s = smt2_dect::GENERIC;

  return s;
}
prop_convt* incremental_solvert::get_minisat2()
{
	auto msat=new satcheck_minisat_no_simplifiert;
	return new bv_pointerst(ns,*msat);
}

prop_convt* incremental_solvert::get_smt2(smt2_dect::solvert solver)
{


	//  const std::string &filename=options.get_option("outfile");

	 // if(filename=="")
	  //{
	    //if(solver==smt2_dect::GENERIC)
	    //  throw "please use --outfile";

	    smt2_dect* smt2_dec = new smt2_dect(
	      ns,
	      "verifox",
	      "Generated by VerifOx " VERIFOX_VERSION,
	      "QF_AUFBV",
	      solver);

	    if(options.get_bool_option("fpa"))
	      smt2_dec->use_FPA_theory=true;

	    return smt2_dec;
	//  }
#if 0
	  else if(filename=="-")
	  {
	    smt2_convt* smt2_conv = new smt2_convt(
	      ns,
	      "cbmc",
	      "Generated by CBMC " CBMC_VERSION,
	      "QF_AUFBV",
	      solver,
	      std::cout);

	    if(options.get_bool_option("fpa"))
	      smt2_conv->use_FPA_theory=true;

	    smt2_conv->set_message_handler(get_message_handler());

	    return smt2_conv;
	  }

	  else
	  {
	    #ifdef _MSC_VER
	    std::ofstream *out=new std::ofstream(widen(filename).c_str());
	    #else
	    std::ofstream *out=new std::ofstream(filename.c_str());
	    #endif

	    if(!*out)
	      throw "failed to open "+filename;

	    smt2_convt* smt2_conv = new smt2_convt(
	      ns,
	      "cbmc",
	      "Generated by CBMC " CBMC_VERSION,
	      "QF_AUFBV",
	      solver,
	      *out);

	    if(options.get_bool_option("fpa"))
	      smt2_conv->use_FPA_theory=true;

	    smt2_conv->set_message_handler(get_message_handler());

	    return new cbmc_solver_with_filet(smt2_conv, out);
	  }
#endif
	//}
}

