Accompanying material for the paper "Generalizing Generalized Tries"
by Ralf Hinze, in Journal of Functional Programming, 10(4),
pp. 327-351, July 2000.

Functions shared by all trie structures.

> module Map (
>     showMaybe,
>     (<>),
>     combine,
> ) where

> showMaybe			:: (Int -> w -> ShowS) -> (Int -> Maybe w -> ShowS)
> showMaybe showw d Nothing	=  showString "Nothing"
> showMaybe showw d (Just w)	=  showParen (d >= 10) (
>				       showString "Just " . showw 10 w)

> (<>)				:: (a -> Maybe b) -> (b -> Maybe c) -> (a -> Maybe c)
> (m1 <> m2) a1			=  case m1 a1 of
>				       Nothing -> Nothing
>				       Just a2 -> m2 a2
	
> combine			:: (w -> w -> w) -> (Maybe w -> Maybe w -> Maybe w)
> combine c Nothing Nothing	=  Nothing
> combine c Nothing (Just v')	=  Just v'
> combine c (Just v) Nothing	=  Just v
> combine c (Just v) (Just v')	=  Just (c v v')
