Accompanying material for the paper "Generalizing Generalized Tries"
by Ralf Hinze, in Journal of Functional Programming, 10(4),
pp. 327-351, July 2000.

Spotted tries for internal nodes.

> module MapFork (
>     MapF,
>     showMapF,
>     emptyF,
>     singleF,
>     lookupF,
>     mergeF,
> ) where
> import Fork
> import Map (showMaybe, (<>), combine)

> data MapF m v			=  TrieF (m (m v))

> showMapF			:: (forall v.(Int -> v -> ShowS) -> (Int -> m v -> ShowS))
>				   -> (Int -> w -> ShowS) -> (Int -> MapF m w -> ShowS)
> showMapF showm showw d (TrieF tf)
>				=  showParen (d >= 10) (
>				       showString "TrieF " . showm (showm showw) 10 tf)

> emptyF			:: (forall v.m v) -> MapF m w
> emptyF e			=  TrieF e

> singleF			:: (forall v.m v) -> (forall v.(k, v) -> m v)
>				   -> ((Fork k, w) -> MapF m w)
> singleF e s (Fork i1 i2, v)	=  TrieF (s (i1, s (i2, v)))

> lookupF			:: (forall v.k -> m v -> Maybe v)
>				   -> (Fork k -> MapF m w -> Maybe w)
> lookupF l (Fork i1 i2) (TrieF tf)
>				=  (l i1 <> l i2) tf

> mergeF			:: (forall v.(v -> v -> v) -> (m v -> m v -> m v))
>				   -> ((w -> w -> w) -> (MapF m w -> MapF m w -> MapF m w))
> mergeF m c (TrieF tf)  (TrieF tf')
>				=  TrieF (m (m c) tf tf')
