Accompanying material for the paper "Generalizing Generalized Tries"
by Ralf Hinze, in Journal of Functional Programming, 10(4),
pp. 327-351, July 2000.

Binary random-access lists.

> module Sequ (
>     Sequ(Empty, Zero, One),
>     sequ,
> ) where
> import Fork

> data Sequ a			=  Empty
>				|  Zero (Sequ (Fork a))
>				|  One a (Sequ (Fork a))
>				   deriving (Show)

Constructing a random-access list.

> sequ				:: [a] -> Sequ a
> sequ				=  foldr incr Empty

> incr				:: a -> Sequ a -> Sequ a
> incr d Empty			=  One d Empty
> incr d (Zero ds)		=  One d ds
> incr d (One d' ds)		=  Zero (incr (Fork d d') ds)
